package gov.va.med.mhv.journal.web.util;

import gov.va.med.mhv.journal.dto.MealItemDTO;

import java.io.Serializable;
import java.math.BigDecimal;

public class MealItemDecorator implements Serializable {

	private static final long serialVersionUID = -5681978817807725907L;

	public static String getDescription(MealItemDTO mealItem) {
		String description = "";

		if (null != mealItem.getQuantity() && (mealItem.getQuantity().compareTo(BigDecimal.ZERO) != 0)) {
			description = getQuantityDescription(mealItem) + " ";
		}

		if (null != mealItem.getServingSize()) {
			description = description + getServingSizeDescription(mealItem) + " ";
		}

		if (null != mealItem.getItem()) {
			description = description + mealItem.getItem() + " ";
		}
		
		return description;
	}

	public static String getPrepMethod(MealItemDTO mealItem) {
		return (null != mealItem.getPrepMethod())? "(" + mealItem.getPrepMethod() + ")" : "";
	}

	public Long getMealItemId(MealItemDTO mealItem) {
		return mealItem.getMealItemId();
	}

	public boolean isPrepMethodAvailable(MealItemDTO mealItem) {
		return mealItem.getPrepMethod() != null;
	}

	private static String getQuantityDescription(MealItemDTO mealItem) {
		BigDecimal quantity = mealItem.getQuantity();
		return quantity == null ? "" : (String) MealItemMap.getQuantities().get(quantity);
	}

	private static String getServingSizeDescription(MealItemDTO mealItem) {
		String servingSize = mealItem.getServingSize();
		return servingSize == null ? "" : (String) MealItemMap.getServingSizes().get(servingSize);
	}

	public static BigDecimal getScaledQuantity(MealItemDTO mealItem) {
		if (mealItem.getQuantity() != null && mealItem.getQuantity().doubleValue() >= 1) {
			return mealItem.getQuantity().setScale(0);
		}
		return mealItem.getQuantity();
	}
}
